
#include "DLL\GComp.h"
#include "Declarations.h"
#include "CommonFunctions.h"
#include "MMS.h"
#include "NameTable.h"
#include "Ordering.h"

void AddFile(FILE* DestFile, CString& FName, bool AddComma = true)
{
	char buff[BUFFER_SIZE];
	long BytesRead;

	FILE *SrcFile = fopen((LPCSTR)FName, "rb");

	if( SrcFile == NULL )
	{
		Msg(0, "ERR: Can't read file '%s' - %s", (LPCSTR)FName, strerror(errno));
		throw NULL;
	}

	if( ftell(DestFile) > 0 && AddComma )
	{
		fputs(",\r\n", DestFile);
	}

	do
	{
		BytesRead = fread(buff, 1, sizeof(buff), SrcFile);
		if( BytesRead > 0 ) fwrite(buff, 1, BytesRead, DestFile);
	} while( BytesRead == sizeof(buff) );

	fclose(SrcFile);
}

void AddDir(FILE* DestFile, CString& DirName, LPCSTR sID)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_MetadataPart);
	CString FName = nt_rec->PrepareFileName(DirName);

	fputs(",\r\n{\"", DestFile);
	fputs(sID, DestFile);
	fputs("\"\r\n", DestFile);
	if( FileExist(FName) ) AddFile(DestFile, FName);

	struct _finddata_t find_data;
	long hFind;

	hFind = _findfirst(DirName+"\\*", &find_data);
	if( hFind != -1 )
	{
		do
		{
			if( (find_data.attrib & _A_SUBDIR) == 0 ) continue;
			if( IsIgnoredFile(find_data.name) ) continue;

			FName.Format("%s\\%s\\%s.%s", DirName, find_data.name, nt_rec->FileName, nt_rec->Ext);
			if( !FileExist(FName) ) continue;

			AddFile(DestFile, FName);
		} while( _findnext(hFind, &find_data) == 0 );
		_findclose(hFind);
	}

	fputs("\r\n}", DestFile);
}

void AddObject(FILE* mmsFile, CString& Dir, MMSObjectType Type, bool AddComma)
{
	CNameTableRecord* nt_rec = NameTable.Find(Type);
	CString DirName  = nt_rec->PrepareDirName(Dir);
	CString FileName = nt_rec->PrepareFileName(Dir);

	if( FileExist(FileName) )
		AddFile(mmsFile, FileName, AddComma);
	else if( DirectoryExist(DirName) )
		AddDir(mmsFile, DirName, nt_rec->sID);
}

void AddPlan(FILE* mmsFile, CString& PlanDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_MetadataPart);
	CString PlanMDP = nt_rec->PrepareFileName(PlanDir);

	fprintf(mmsFile, ",\r\n{");
	AddFile(mmsFile, PlanMDP, false);
	fprintf(mmsFile, ",\r\n{\"Accounts\"");

	CObjectOrdering Order(3);
	if( Order.OpenFile(PlanDir) )
	{
		CString AccFName;
		while( Order.ReadString() )
		{
			AccFName.Format("%s\\%s", PlanDir, Order.GetValue(2));
			AddFile(mmsFile, AccFName, true);
		}
	}

	fprintf(mmsFile, "\r\n}}");
}

void AddPlans(FILE* mmsFile, CString& BuhDir)
{
	CNameTableRecord* nt_rec = NameTable.Find(MMS_Plans);
	CString PlansDir = nt_rec->PrepareDirName(BuhDir);

	fprintf(mmsFile, ",\r\n{\"Plans\"");

	CObjectOrdering Order(3);
	if( Order.OpenFile(PlansDir) )
	{
		CString PlanDir;
		while( Order.ReadString() )
		{
			PlanDir.Format("%s\\%s", PlansDir, Order.GetValue(2));
			AddPlan(mmsFile, PlanDir);
		}
	}
	fprintf(mmsFile, "\r\n}");
}

void AddBuh(FILE* mmsFile)
{
	CString csDirectoryName = TaskParameters.DirectoryName;
	CNameTableRecord* nt_rec = NameTable.Find(MMS_Buh);
	CString BuhDir = nt_rec->PrepareDirName(CString(TaskParameters.DirectoryName));

	fputs(",\r\n{\"Buh\",{", mmsFile);
	AddObject(mmsFile, csDirectoryName, MMS_Buh, false);
	AddObject(mmsFile, BuhDir, MMS_AccParams, true);
	AddPlans(mmsFile, BuhDir);
	AddObject(mmsFile, BuhDir, MMS_ProvParams, true);
	AddObject(mmsFile, BuhDir, MMS_OperParams, true);
	AddObject(mmsFile, BuhDir, NT_AccListForm, true);
	AddObject(mmsFile, BuhDir, NT_UnknownListForm, true);
	AddObject(mmsFile, BuhDir, NT_ProvListForm, true);
	AddObject(mmsFile, BuhDir, MMS_SbKind, true);
	AddObject(mmsFile, BuhDir, MMS_TypOpersDef, true);
	AddObject(mmsFile, BuhDir, MMS_CorrProvsDef, true);
	AddObject(mmsFile, BuhDir, MMS_ProvHardFldDef, true);
	AddObject(mmsFile, BuhDir, MMS_OperJournal, true);
	fputs("\r\n}}", mmsFile);
}

FILE* AssembleMMS()
{
	CString csDirectoryName = TaskParameters.DirectoryName;
	FILE *mmsFile;
	char* fname = NULL;	
	fname =  _tempnam( NULL, "tmp_");//"c:\\tmp"
	mmsFile = fopen(fname, "w+b");
	if(fname!=NULL)
	{
		free(fname);
		fname = NULL;
	}	
	if( mmsFile == NULL )
	{
		Msg(0, "ERR: Can't create temporary file");
		throw NULL;
	}

	if( TaskParameters.CompoundType == external_report )
	{
		AddObject(mmsFile, csDirectoryName, NT_MainMetadataStream, false);
	}
	else
	{
		fputs("{\r\n", mmsFile);

		AddObject(mmsFile, csDirectoryName, MMS_MainDataContDef, false);
		AddObject(mmsFile, csDirectoryName, MMS_TaskItem, true);
		AddObject(mmsFile, csDirectoryName, MMS_GenJrnlFldDef, true);
		AddObject(mmsFile, csDirectoryName, MMS_DocSelRefObj, true);
		AddObject(mmsFile, csDirectoryName, MMS_DocNumDef, true);
		AddObject(mmsFile, csDirectoryName, MMS_Consts, true);
		AddObject(mmsFile, csDirectoryName, MMS_SbCnts, true);
		AddObject(mmsFile, csDirectoryName, MMS_Registers, true);
		AddObject(mmsFile, csDirectoryName, MMS_Documents, true);
		AddObject(mmsFile, csDirectoryName, MMS_Journalisters, true);
		AddObject(mmsFile, csDirectoryName, MMS_EnumList, true);
		AddObject(mmsFile, csDirectoryName, MMS_ReportList, true);
		AddObject(mmsFile, csDirectoryName, MMS_CalcJournals, true);
		AddObject(mmsFile, csDirectoryName, MMS_Calendars, true);
		AddObject(mmsFile, csDirectoryName, MMS_CalcAlgorithms, true);
		AddObject(mmsFile, csDirectoryName, MMS_RecalcRules, true);
		AddObject(mmsFile, csDirectoryName, MMS_CalcVars, true);
		AddObject(mmsFile, csDirectoryName, MMS_Groups, true);
		AddObject(mmsFile, csDirectoryName, MMS_DocumentStreams, true);

		AddBuh(mmsFile);

		fputs("\r\n}", mmsFile);
	}

	return mmsFile;
}
