
#ifndef NAME_TABLE_H
#define NAME_TABLE_H

#include "Declarations.h"

class CNameTableRecord
{
public:
	MMSObjectType Type;
	CString Type1C;
	CString sID;
	CString StorageName;
	bool HasSuffix;
	CString Dir;
	CString FileName;
	CString Ext;

public:
	CString PrepareFileName(CString& Dir, CMMSObject* object = NULL);
	CString PrepareDirName(CString& Dir, CMMSObject* object = NULL);
	CString PrepareStorageName(int suffix = 0);
};

class CNameTable
{
private:
	CArray<CNameTableRecord*, CNameTableRecord*&> NameTable;
	int nRecords;

public:
	CNameTable() {};
	void RusConstructor();
	void EngConstructor();
	~CNameTable();

	void AddRecord(MMSObjectType Type, LPCSTR Type1C, LPCSTR sID, 
		LPCSTR StorageName, bool HasSuffix, 
		LPCSTR Dir, LPCSTR FileName = NULL, LPCSTR Ext = NULL);
	
	CNameTableRecord* Find(MMSObjectType Type);
	CNameTableRecord* Find(CString& sID);
	CNameTableRecord* FindByType1C(CString& Type1C);

	inline int GetNRecords() {return nRecords;};
	inline CNameTableRecord* operator[](int i) {return NameTable[i];};
};

#endif