
#ifndef Rights_H
#define Rights_H

#include "Declarations.h"
#include "Lexer.h"


class CUserRightsProp
{
private:
	DWORD Type;
	DWORD Value;

	typedef struct {
		DWORD ID;
		const char* sID;
	} TTypeTable;
	static TTypeTable TypeTable[];

	const char* TypeAsString();
	DWORD TypeFromString(CString& strType);
	const char* ValueAsString();
	DWORD ValueFromString(CString& strValue);

public:
	CUserRightsProp();

	void Read(CStorage& Storage);
	void BeautyString(CString& String, int level);

	void SetValues(CString& strType, CString& strValue);
	void Write(IStream* pStream);
};

class CUserRightsBlock
{
private:
	DWORD Type;
	DWORD MetadataID;
	CString Metadata_sID;
	DWORD nProps;
	CArray<CUserRightsProp, CUserRightsProp&> Props;

	typedef struct {
		DWORD ID;
		const char* sID;
	} TBlockType;
	static TBlockType BlockTypes[];

	const char* TypeAsString();
	DWORD TypeFromString(CString& strType);

public:
	CUserRightsBlock();
	CUserRightsBlock& operator=(CUserRightsBlock& Block);

	void Read(CStorage& Storage);
	void BeautyString(CString& String, int level);

	void ReadFromFile(CLexer& Lexer, CString& strType, CString& strMetadataID);
	void Write(IStream* pStream);

	static int __cdecl CompareBysID(const void *elem1, const void *elem2);
};

class CUserRights
{
private:
	DWORD ID;
	CString Description;
	DWORD nBlocks;
	CArray<CUserRightsBlock, CUserRightsBlock&> Blocks;

public:
	CUserRights();

	void Read(CStorage& Storage);
	void BeautyString(CString& String);
	void WriteToFile(CStorage& Storage, CString FileName);

	void ReadFromFile(CString& FileName);
	void Write(CStorage& Storage, CString& StreamName);
};

void DecompileUserRights(CString& Dir, CStorage& Storage);
void CompileUserRights(CStorage& Storage, CString& Dir);


#endif