
#include "DLL\GComp.h"
#include "Storage.h"
#include "CommonFunctions.h"
#include "MMS.h"
#include "Container.h"
#include "DialogForm.h"
#include "UI.h"
#include "Rights.h"
#include "NameTable.h"
#include "Ordering.h"
#include "MMS_Filter.h"

///////////////////////////////////////////////////////////////////////
///////////  class CMMSObject methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSObject::ExtractString(CStorage& Storage, GCString& DestDir, GCString& Str, MMSObjectType MMS_Type)
{
	CNameTableRecord* nt_rec = NameTable.Find(MMS_Type);
	Storage.CopyStringToFile(Str, nt_rec->PrepareFileName(DestDir));
}

bool CMMSObject::ExtractMetadata(GCString& DestDir, MMSObjectType MMS_Type, CStorage& TypedTextStorage)
{
	CNameTableRecord* nt_rec = NameTable.Find(MMS_Type);

	MMS_Filter.Down();
	bool ToExtract = MMS_Filter.Test(this, nt_rec);
	if( ToExtract )
	{
		CBeautyString Content;
		BeautyString(Content, 0);

		if( !nt_rec->Dir.IsEmpty() )
		{
			GCString Dir = nt_rec->PrepareDirName(DestDir, this);
			CreateDirectory(Dir);
			ExtractDescriptions(Dir+"\\", TypedTextStorage, true);
		}
		
		GCString FName = nt_rec->PrepareFileName(DestDir, this);
		CreateDirectory(DestDir);
		TypedTextStorage.CopyStringToFile(Content, FName);
	}
	MMS_Filter.Up();

	return ToExtract;
}

void CMMSObject::ExtractMetadata(GCString& DestDir, CStorage& TypedTextStorage)
{
	ExtractMetadata(DestDir, NT_MetadataPart, TypedTextStorage);
}

void CMMSObject::ExtractDescriptions(GCString& FNamePrefix, CStorage& TypedTextStor, bool StdName)
{
	if( MMS_Type == MMS_Property ) return; //    

	CNameTableRecord* nt_rec_obj = NameTable.Find(MMS_Type);
	CNameTableRecord* nt_rec = NameTable.Find(NT_UserHelpStor);
	CNameTableRecord* nt_rec_file = NameTable.Find(NT_UserHelp);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec_obj) || MMS_Filter.Test(NULL, nt_rec_file) )
	{
		GCString StorName = nt_rec->PrepareStorageName(ID);
		GCString NewPrefix = FNamePrefix;
		GCString Suffix;
		
		if( ID_Type != IDT_NoID && 
			(nt_rec_obj == NULL || nt_rec_obj->Type1C == "sID") )
		{
			if( ID_Type == IDT_OnlyTextual )
				Suffix.Format("%s.", sID);
			else if( ID_Type == IDT_OnlyNumeric )
				Suffix.Format("%s.%i.", nt_rec_file->FileName, ID);
			else if( sID.IsEmpty() || !IsValidFileName(sID) )
				Suffix.Format("%s.%i.", nt_rec_file->FileName, ID);
			else
				Suffix.Format("%s.", sID);
		}

		InplaceTranslit(Suffix);
		NewPrefix += Suffix;

		if( ID_Type == IDT_BothIDs && 
			!TypedTextStor.ObjectExtracted(this) && 
			TypedTextStor.StorageExist(StorName) )
		{
			GCString FName;

			if( StdName || Suffix.IsEmpty() )
				FName.Format("%s%s.%s", FNamePrefix, nt_rec_file->FileName, nt_rec_file->Ext);
			else
				FName.Format("%s%s", NewPrefix, nt_rec_file->Ext);

			TypedTextStor.Open(StorName);
			TypedTextStor.CopyToFile(nt_rec_file->PrepareStorageName(ID), FName);
			TypedTextStor.AddToExtractedList(FName, this);
			TypedTextStor.Close();
		}

		if( MMS_Type != MMS_Plan)
		{
			for( int i = 0; i < GetNChildren(); i++ )
			{
				GetChild(i)->ExtractDescriptions(NewPrefix, TypedTextStor, false);
			}
		}
	}
	MMS_Filter.Up();
}

void CMMSObject::Decompile(GCString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	if( sID.IsEmpty() ) return;

	CNameTableRecord* nt_rec = NameTable.Find(MMS_Type);
	if( nt_rec == NULL ) return;

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		GCString ObjDir;
		if( !nt_rec->Dir.IsEmpty() )
		{
			ObjDir = nt_rec->PrepareDirName(Dir, this);
			CreateDirectory(ObjDir);
		}
		else
			ObjDir = Dir;

		Msg(2, "%s", sID);

		//
		ExtractMetadata(Dir, MMS_Type, TypedTextStorage);
		//
		ExtractDescriptions(ObjDir+"\\", TypedTextStorage, true);
	}
	MMS_Filter.Up();

	SendInfoMessage(InfoMsg_Progress, ++TotalObjectsProcessed);
}

void CMMSObject::ExtractMoxelPages(GCString& DestDir, CStorage& WBStorage)
{
	CNameTableRecord* nt_rec_mxl = NameTable.Find(NT_MoxelSheet);
	CContainer WBContent;

	WBStorage.ParseStream(&WBContent, GCString("Container.Contents"), false);

	//Analyze Container.Contents and extract moxel pages if any.
	GCString std_tab_name("Moxel WorkPlace");
	GCString ID_mxl("Moxcel.Worksheet");
	GCString mxlFName;
	CObjectOrdering Order(3);
	GCString tab_name;
	
	for( int i = 0; i < WBContent.GetNChildren(); i++ )
	{
		CContainerRecord* rec = (CContainerRecord*)WBContent.GetChild(i);
		if( rec->Type != ID_mxl ) continue;

		tab_name = (LPCSTR)(rec->ObjectName); // ,   ,      
		GCString page_suffix = Suffix(rec->StreamName);
		if( tab_name == std_tab_name )
			tab_name = "";
		else
		{
			if( MangleFileName(tab_name) > 0 )
				Msg(2, "MXL %s replaced by %s", rec->ObjectName, tab_name);
		}

		mxlFName.Format("%s.%s", tab_name, nt_rec_mxl->Ext);

		if( TaskParameters.NoEmptyMxl ) //  
		{
			long size = WBStorage.GetStreamSize(rec->StreamName);
			if( size == 147 || size == 139 ) continue;
		}

		if( !DirectoryExist(DestDir) ) CreateDirectory(DestDir);
		WBStorage.CopyToFile(rec->StreamName, DestDir+"\\"+Translit(mxlFName));
		
		Order.Add(page_suffix, mxlFName, Translit(mxlFName), rec->ObjectName);
	}

	if( Order.Order.GetLength() > 0 ) Order.WriteFile(WBStorage, DestDir);
}

void CMMSObject::ExtractWorkBook(GCString& DestDir, CStorage& Storage, CMMSObject* Parent)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_Workbook);

	if( TaskParameters.CompoundType != external_report ) //    WorkBook,     
		if( !Storage.Open(nt_rec->StorageName) )
			return; // ,    

	CreateDirectory(DestDir); // TODO ,       CreateDirectory()?

	// 
	ExtractStreamByType(Storage, NT_FormModule, DestDir, true);

	// 
	CNameTableRecord* nt_rec_dlg = NameTable.Find(NT_DialogForm);
	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec_dlg) )
	{
		GCString StorName = nt_rec_dlg->PrepareStorageName();
		if( Storage.StreamExist(StorName) )
		{
			Msg(2, "Form of: %i, %s", ID, sID);
			CDialogForm DialogForm(Parent);
			try
			{
				Storage.ParseStream(&DialogForm, StorName, true);
				DialogForm.WriteToFile(Storage, nt_rec_dlg->PrepareFileName(DestDir));
			}
			catch(...) //-    -     
			{
				Msg(0, "WARN: error parsing form of %i: %s. Extracting stream as is.", ID, sID);
				ExtractStreamByType(Storage, NT_DialogForm, DestDir);
			}
		}
	}
	MMS_Filter.Up();

	// 
	MMS_Filter.Down();
	if( MMS_Filter.Test(GCString("")) || MMS_Filter.Test(GCString("MoxelPages")) )
	{
		ExtractMoxelPages(DestDir, Storage);

		//Container.Profile     ,     
		GCString ContProfName = "Container.Profile";
		if( Storage.OpenStream(ContProfName) )
		{
			//      ,      
			//  - ,   {"MoxelName","",""}
			GCString EmptyHeader = "{\n{\"MoxelName\",\"\",\"\"},\n{\"MoxelPos\"";
			if( 0 != Storage.CompareWithString(EmptyHeader) )
			{
				Storage.CopyToFile(DestDir+"\\"+ContProfName);
			}
			Storage.CloseStream();
		}
	}
	MMS_Filter.Up();

	if( TaskParameters.CompoundType != external_report )
		Storage.Close();
}

void CMMSObject::ExtractListForms(CFormDescrList& Forms, GCString& Dir, CStorage& Storage, GCString Prefix)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_ListForm);
	GCString StorName;

	for( int i = 0; i < Forms.GetNChildren(); i++ )
	{
		CMMSObject* Form = Forms.GetChild(i);
		MMS_Filter.Down();
		if( MMS_Filter.Test(Form, nt_rec) || MMS_Filter.Test(GCString("")) )
		{
			GCString FormDir;
			FormDir.Format("%s\\%s.%s", Dir, Translit(Form->sID), nt_rec->Ext);
			
			StorName.Format("%s%i", Prefix, Form->ID);
			if( Storage.Open(StorName) )
			{
				ExtractWorkBook(FormDir, Storage, this);
				Storage.Close();
			}
		}
		MMS_Filter.Up();
	}
}

void CMMSObject::ExtractStreamByType(CStorage& Storage, MMSObjectType MMS_Type, GCString& Dir, bool NotExtractEmpty)
{
	CNameTableRecord* nt_rec = NameTable.Find(MMS_Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		CStorage SubStorage(Storage);
		if( SubStorage.OpenStream(nt_rec->PrepareStorageName(ID)) )
		{
			SubStorage.GetCleanStream();
			if( !NotExtractEmpty || SubStorage.StreamInfo.Size > 0 )
				SubStorage.CopyToFile(nt_rec->PrepareFileName(Dir));
		}
	}
	MMS_Filter.Up();
}

void CMMSObject::ExtractOrdering(CStorage& Storage, GCString& DestDir)
{
	if( TaskParameters.NoOrdering ) return;

	int nProps = GetNChildren();
	if( nProps == 0 ) return;

	CObjectOrdering Order(2);

	for( int i = 0; i < nProps; i++ )
	{
		CMMSObject* obj = GetChild(i);
		Order.Add(obj->ID, obj->sID, obj->sID);
	}

	Order.WriteFile(Storage, DestDir);
}

void CMMSAttributes_SF::Decompile(GCString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	if( sID.IsEmpty() ) return;

	CNameTableRecord* nt_rec = NameTable.Find(MMS_Type);
	if( nt_rec == NULL ) return;

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		GCString ObjDir;
		if( !nt_rec->Dir.IsEmpty() )
			ObjDir = nt_rec->PrepareDirName(Dir, this);
		else
			ObjDir = Dir;

		Msg(2, "%s", sID);

		if( TaskParameters.MetadataBySubfolders )
		{
			for( int i = 0; i < GetNChildren(); i++ )
			{
				CMMSObject* Child = GetChild(i);
				GCString ChildDir = Child->GetObjectDir(ObjDir);
				Child->ExtractMetadata(ChildDir, TypedTextStorage);
				Child->ExtractDescriptions(ChildDir+"\\", TypedTextStorage, true);
			}
			ExtractOrdering(Storage, ObjDir);
		}
		else
		{
			//
			ExtractMetadata(Dir, MMS_Type, TypedTextStorage);
			//
			ExtractDescriptions(ObjDir+"\\", TypedTextStorage, true);
		}
	}
	MMS_Filter.Up();

	SendInfoMessage(InfoMsg_Progress, ++TotalObjectsProcessed);
}


///////////////////////////////////////////////////////////////////////
///////////  class CMMS methods  //////////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMS::ExtractStorage(GCString& Dir, CStorage& Storage, MMSObjectType MMS_Type, bool WithContainerCOntents)
{
	CNameTableRecord* nt_rec = NameTable.Find(MMS_Type);

	MMS_Filter.Down();
	if( MMS_Filter.Test(NULL, nt_rec) )
	{
		GCString DestDir = nt_rec->PrepareDirName(Dir);
		CStorage SrcStorage(Storage);

		if( SrcStorage.Open(nt_rec->PrepareStorageName(ID)) )
		{
			CreateDirectory(DestDir);
			if( !SrcStorage.Extract(DestDir, WithContainerCOntents) ) remove(DestDir);
		}
	}
	MMS_Filter.Up();
}

void CMMS::ExtractCommonMXL(GCString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec_gd = NameTable.Find(NT_GlobalData);
	CNameTableRecord* nt_rec = NameTable.Find(NT_CommonMXL);

	MMS_Filter.Down();
	if( MMS_Filter.Test(NULL, nt_rec) )
	{
		GCString GDDir = nt_rec->PrepareDirName(Dir);
		
		GCString StorName = nt_rec_gd->StorageName;
		StorName += "\\";
		StorName += nt_rec->StorageName;
		StorName += "\\WorkBook";
		
		CStorage GDStorage(Storage);
		if( GDStorage.Open(StorName) )
		{
			ExtractMoxelPages(GDDir, GDStorage);
		}
	}
	MMS_Filter.Up();
}


/*
void CMMS::DeleteUnusedObjects(CStorage& Storage)
{
	int i;

	for( i = 0; i < GetNChildren(); i++ )
		GetChild(i)->Used = true;


	CMMSObject* frm = Storage.ParseStream(NameTable.Find(NT_DialogForm)->PrepareStorageName(0), false);
	if( frm == NULL )
		return;

	CMMSObject* Controls = frm->FindChild(GCString("Controls"));
	for( i = 0; i < Controls->GetNChildren(); i++ )
	{
		int nProps = Controls->GetChild(i)->GetNChildren();
		GCString& sWndClass = Controls->GetChild(i)->GetChild(0)->sID;
		GCString sTypeLetter, sTypeID;
		if( isdigit(sWndClass[0]) ) // ,  1    ?!
		{
			sTypeLetter = Controls->GetChild(i)->GetChild(12)->sID;
			sTypeID = Controls->GetChild(i)->GetChild(15)->sID;
		}
		else
		{
			sTypeLetter = Controls->GetChild(i)->GetChild(13)->sID;
			sTypeID = Controls->GetChild(i)->GetChild(16)->sID;
		}

		int ID = atoi(sTypeID);
		if( ID != 0 ) 
			MarkUsed(ID);
	}

	for( i = 0; i < GetNChildren(); i++ )
	{
		if( GetChild(i)->MMS_Type == MMS_Buh ) continue;
		if( GetChild(i)->MMS_Type == MMS_TaskItem ) continue;
		GetChild(i)->DeleteUnused();
	}

	delete frm;
}
*/

void CMMS::ExtractPictureGallery(GCString& Dir, CStorage& Storage)
{
	CNameTableRecord* nt_rec = NameTable.Find(NT_PictureGallery);
	GCString DestDir = nt_rec->PrepareDirName(Dir);
	CStorage SrcStorage(Storage);

	if( SrcStorage.Open(nt_rec->PrepareStorageName(ID)) )
	{
		CreateDirectory(DestDir);
		if( !SrcStorage.Extract(DestDir, false) ) remove(DestDir);
	}
}

void CMMS::BuildObjNameCache(TCompareFunction sort_method, GCString& Dir, CStorage& Storage)
{
	//Build names cache 
	CMMSObject::BuildObjNameCache(ObjNameCache, GCString());

	// and save it
	if( TaskType == TaskType_Decompile )
	{
		GCString NamesStr, str;
		for( int i = 0; i < ObjNameCache.GetSize(); i++ )
		{
			str.Format("%10i\t%s\r\n", ObjNameCache[i].ID, ObjNameCache[i].Name);
			NamesStr += str;
		}
		CNameTableRecord* nt_rec = NameTable.Find(NT_ObjNameTable);
		GCString FileName = nt_rec->PrepareFileName(Dir);
		if( !(TaskParameters.CompoundType == external_report && TaskParameters.TruncateMMS) )
			Storage.CopyStringToFile(NamesStr, FileName);
	}
	//sorting by ID only after saving
	qsort(ObjNameCache.GetData(), ObjNameCache.GetSize(), 
		sizeof(TObjNameCacheRecord), 
		sort_method);
}

void CMMS::ReadObjNameCache(GCString& Dir)
{
	if( TaskType != TaskType_Compile )
		return; //    

	CNameTableRecord* nt_rec = NameTable.Find(NT_ObjNameTable);
	GCString FileName = nt_rec->PrepareFileName(Dir);
	if( !FileExist(FileName) )
		return;
	
	CLexer Lexer(FileName);
	GCString Token, Value;
	TObjNameCacheRecord new_entry;
	while( Lexer.GetToken(Token, " \t\r\n") )
	{
		Lexer.GetRest(Value);
		new_entry.ID = atoi(Token);
		new_entry.Name = Value;
		ObjNameCache.Add(new_entry);
	}

	qsort(ObjNameCache.GetData(), ObjNameCache.GetSize(), 
		sizeof(TObjNameCacheRecord), 
		ObjNameCache_compare_str);
}

void CMMS::Decompile(GCString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	//       -      -
	MainDataContDef.MD_ver = 10009;

	//Build names cache and save it
	BuildObjNameCache(ObjNameCache_compare_id, Dir, Storage);

	//   ,     
	if( TaskParameters.CompoundType == external_report	)
	{
		//DeleteUnusedObjects(Storage);
		if( !TaskParameters.TruncateMMS )
			ExtractMetadata(Dir, TypedTextStorage);
		ExtractWorkBook(Dir, Storage, NULL);
		ExtractStreamByType(Storage, NT_ErtUserHelp, Dir, true);
		ExtractStorage(Dir, Storage, NT_PictureGallery, false);
		return;
	}

	SendInfoMessage(InfoMsg_Total, CountObjects());
	TotalObjectsProcessed = 0;

	int nProps = GetNChildren();
	for( int i = 0; i < nProps; i++ )
	{
		CMMSObject *obj = GetChild(i);
		obj->Decompile(Dir, Storage, TypedTextStorage);
	}

	// 
	ExtractStreamByType(TypedTextStorage, NT_GlobalModule, Dir);
	// 
	ExtractCommonMXL(Dir, Storage);
	
	//
	ExtractStorage(Dir, Storage, NT_PictureGallery, false);

	// 
	DecompileUI(Dir, Storage);
	// 
	DecompileUserRights(Dir, Storage);

	// 
	ExtractStreamByType(Storage, NT_GUIDData, Dir);
	ExtractStreamByType(Storage, NT_TagStream, Dir);

	//
	CNameTableRecord* nt_rec_descr = NameTable.Find(NT_UserHelpStor);
	GCString DescrDir = nt_rec_descr->PrepareDirName(Dir);
	ExtractDescriptions(DescrDir+"\\", TypedTextStorage, false);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSReport methods  ////////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReport::Decompile(GCString& Dir, CStorage& Storage, GCString& Prefix, CStorage& TypedTextStorage)
{
	MMS_Filter.Down();
	if( MMS_Filter.Test(this, NULL) )
	{
		GCString StorName;

		Msg(2, " () %s", sID);

		GCString RptDir = GetObjectDir(Dir);
		CreateDirectory(RptDir);
		
		StorName.Format("%s%i", Prefix, ID);
		if( Storage.Open(StorName) )
		{
			ExtractWorkBook(RptDir, Storage, NULL);
			Storage.Close();
		}

		ExtractMetadata(RptDir, TypedTextStorage);
		ExtractDescriptions(RptDir+"\\", TypedTextStorage, true);
	}
	MMS_Filter.Up();

	SendInfoMessage(InfoMsg_Progress, ++TotalObjectsProcessed);
}

///////////////////////////////////////////////////////////////////////
///////////  class CMMSReportList methods  /////////////////////////////
///////////////////////////////////////////////////////////////////////
void CMMSReportList::Decompile(GCString& Dir, CStorage& Storage, CStorage& TypedTextStorage)
{
	int nChildren = GetNChildren();
	if( nChildren== 0 ) return;

	CNameTableRecord* nt_rec = NameTable.Find(sID);

	MMS_Filter.Down();
	if( MMS_Filter.Test(this, nt_rec) )
	{
		GCString ReportsDir = nt_rec->PrepareDirName(Dir);

		CreateDirectory(ReportsDir);

		if( Storage.Open(nt_rec->StorageName) )
		{
			GCString ReportStorName = nt_rec->StorageName + "_Number";
			for( int i = 0; i < nChildren; i++ )
			{
				CMMSReport* rpt = (CMMSReport*)GetChild(i);
				rpt->Decompile(ReportsDir, Storage, ReportStorName, TypedTextStorage);
			}
			Storage.Close();
		}

		ExtractOrdering(Storage, ReportsDir);
	}
	MMS_Filter.Up();
}

